*** Table 2:  Congressional Election (county-level)

cd "$path"
global data "$path/data/"
global output "$path/results"

estimates clear 

*** OPEN MAIN CZ DTA 
use  "$data/main_CZ.dta", clear

 
foreach t in 40 50 60 {
gen y_`t'=0
replace y_`t'=1 if year==19`t'
gen fr_black_40_y`t'=fr_black_40*y_`t'
gen cong_dem_40_y`t'=cong_dem_40*y_`t'
gen dem_40_y`t'=dem_40*y_`t'
}
.

egen stateyear=group(statefip year)

xtset cz year, delta(10)
global controls fr_black_40_y* dem_40_y*



********************************************************************
cd "$output"


// Panel A  
ivreg2 D_cong_dem (D_fr_black=Z_p40)  i.stateyear $controls [aw=totpop_40], cl(cz) ffirst savefirst
local F=e(widstat)
      su D_cong_dem [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table2_CZ.xls, excel nocon replace ///
keep (D_fr_black)  dec(3) addstat( "F-stat", `F')  addtext(Specification, FD, 1940 Black Share, X, 1940 Dem Incumbent, X, Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

est restore _ivreg2_D_fr_black
outreg2 using Table2_CZ.xls, excel nocon append ///
keep (Z_p40)  dec(3)




// Panel B 
ivreg2 D_cong_turnout (D_fr_black=Z_p40)  i.stateyear $controls [aw=totpop_40], cl(cz) ffirst savefirst
local F=e(widstat)
      su D_cong_turnout [aw=totpop_40] if e(sample)
      local mout=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local mtr=round(r(mean), .001)
      su D_fr_black [aw=totpop_40] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table2_CZ.xls, excel nocon append ///
keep (D_fr_black)  dec(3) addstat( "F-stat", `F')  addtext(Specification, FD, 1940 Black Share, X, 1940 Dem Incumbent, X, Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

est restore _ivreg2_D_fr_black
outreg2 using Table2_CZ.xls, excel nocon append ///
keep (Z_p40)  dec(3)




